dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 6, 230, 350, "assets/images/table/castle_6", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 2, 300, 220, "assets/images/table/castle_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 6, 230, 480, "assets/images/table/castle_6", "assets/images/food/item_mark3", "R" );

useFloAsServer = 0;

useWineTable = 1;

numMoodBoosts = 3;
maxCoupleHappiness = 500;


--Level 5.2

--Group 1
guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.likes={male02};
guest.matchType = NOT_GUEST + female04;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = NOT_GUEST + female01;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.likes={male02};
guest.matchType = table3;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 5, 1000);

--Group 2
guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.likes={male04};
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(6, 10, 25000);


--Group 3
guest = LManager.GenGuest(male03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(11, 13, 70000);


--Group 4
guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + male04;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = male01;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
guest.percentRequestTissue = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(uncle);
guest.matchType = male01;
guest.percentRequestCoffee = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 17, 100000);


--Group 5
guest = LManager.GenGuest(male01);
guest.matchType = aunt;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male02;
guest.percentRequestDrink = 40;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male02);
guest.matchType = table3;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table3;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(18, 21, 120000);

-- Group 6

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table3;
guest.percentRequestTissue = 70;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + uncle;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(22, 26, 180000);




LManager:AdjustGuestTolerance(140);

LManager:AddReseatingRequestForGuest(85000, female03);
LManager:AddReseatingRequestForGuest(105000, male02);
LManager:AddReseatingRequestForGuest(185000, male01);
LManager:AddReseatingRequestForGuest(220000, female04);

LManager:SetLevelSetting ("dogDelay", 75000); 
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("cakeTipDelay", 100000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:AddQuinnEvent( "fx/fx_chef_table_fire.lua", 660, 155, 130000 );


-- Set up the Level Settings
LManager:SetLevelNumber(5,2);
LManager:SetLevelScores(12000, 16500);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/uptempo_3.ogg","assets/audio/music/Disco Dance 1.ogg");
LManager:SetBackgroundImage("assets/images/bg_castle");
LManager:SetChairImage("assets/images/table/chair05");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );